//
// AbstractDelegate.h
//
// $Id: //poco/1.4/Foundation/include/Poco/AbstractDelegate.h#4 $
//
// Library: Foundation
// Package: Events
// Module:  AbstractDelegate
//
// Implementation of the AbstractDelegate template.
//
// Copyright (c) 2006-2011, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Foundation_AbstractDelegate_INCLUDED
#define Foundation_AbstractDelegate_INCLUDED


#include "Poco/Foundation.h"


namespace Poco {


template <class TArgs> 
class AbstractDelegate
	/// Base class for Delegate and Expire.
{
public:
	AbstractDelegate()
	{
	}

	AbstractDelegate(const AbstractDelegate& del)
	{
	}

	virtual ~AbstractDelegate() 
	{
	}

	virtual bool notify(const void* sender, TArgs& arguments) = 0;
		/// Invokes the delegate's callback function.
		/// Returns true if successful, or false if the delegate
		/// has been disabled or has expired.

	virtual bool equals(const AbstractDelegate& other) const = 0;
		/// Compares the AbstractDelegate with the other one for equality.

	virtual AbstractDelegate* clone() const = 0;
		/// Returns a deep copy of the AbstractDelegate.

	virtual void disable() = 0;
		/// Disables the delegate, which is done prior to removal.
		
	virtual const AbstractDelegate* unwrap() const
		/// Returns the unwrapped delegate. Must be overridden by decorators
		/// like Expire.
	{
		return this;
	}
};

template <> 
class AbstractDelegate<void>
	/// Base class for Delegate and Expire.
{
public:
	AbstractDelegate()
	{
	}

	AbstractDelegate(const AbstractDelegate& del)
	{
	}

	virtual ~AbstractDelegate() 
	{
	}

	virtual bool notify(const void* sender) = 0;
		/// Invokes the delegate's callback function.
		/// Returns true if successful, or false if the delegate
		/// has been disabled or has expired.

	virtual bool equals(const AbstractDelegate& other) const = 0;
		/// Compares the AbstractDelegate with the other one for equality.

	virtual AbstractDelegate* clone() const = 0;
		/// Returns a deep copy of the AbstractDelegate.

	virtual void disable() = 0;
		/// Disables the delegate, which is done prior to removal.
		
	virtual const AbstractDelegate* unwrap() const
		/// Returns the unwrapped delegate. Must be overridden by decorators
		/// like Expire.
	{
		return this;
	}
};

} // namespace Poco


#endif // Foundation_AbstractDelegate_INCLUDED
